<?php
/**
 * DuoLamPHP FrameWork 
 * http://www.imoi.cn
 *
 * Copyright (c) 2011 Mo Yi
 * 
 * @author Mo Yi root@imoi.cn
 */

!defined('DL_Root') && exit ( 'Access Denied!' );

class Mem extends DCacheDriver{

	private $mem;

	private $zip;

	public function __construct()
	{
		if (!extension_loaded('memcache'))
		{
			EasyBase::e('memcached扩展没有开启!');
        }
		$this->mem = new Memcache();
		$this->mem->addServer(DuoLamBase::$config['mem']['host'],DuoLamBase::$config['mem']['port'],DuoLamBase::$config['mem']['p'],DuoLamBase::$config['mem']['weight'],DuoLamBase::$config['mem']['time']);
		$this->zip = (DuoLamBase::$config['mem']['zip'] ? MEMCACHE_COMPRESSED : 0);
	}
	
	public function set($key, $value, $expire = 600)
	{
		return $this->mem->set($key, $value, $this->compression, $expire);
	}

	public function get($key)
	{
		return $this->mem->get($key);
	}

	public function del($key)
	{
		return $this->mem->delete($key);
	}

	public function delAll() {
		return $this->mem->flush();
	}

	public function is($key)
	{
		return ($this->get($key) === false ? false : true);
	}
	
}
?>